local cockpit = folder.."../../../Cockpit/Scripts/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

local res = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")

join(res.keyCommands,{

{down = iCommandEnginesStart, name = _('Auto Start'),	category = _('Cheat')},
{down = iCommandEnginesStop,  name = _('Auto Stop') ,	category = _('Cheat')},
{down = device_commands.Button_1, cockpit_device_id = 0, value_down = 1.0, name = _('Recorder On'), category = _('Cheat')},
{down = device_commands.Button_2, cockpit_device_id = 0, value_down = 1.0, name = _('Recorder Off'), category = _('Cheat')},

-- General
{down = iCommandCockpitShowPilotOnOff, name = _('Show pilot body'), category = _('General')},

-- Flight Control
{down = iCommandPlaneUpStart,			up = iCommandPlaneUpStop,			name = _('Aircraft Down'),			category = _('Flight Control')},
{down = iCommandPlaneDownStart,			up = iCommandPlaneDownStop,			name = _('Aircraft Up'),			category = _('Flight Control')},
{down = iCommandPlaneLeftStart,			up = iCommandPlaneLeftStop,			name = _('Aircraft Bank Left'),		category = _('Flight Control')},
{down = iCommandPlaneRightStart,		up = iCommandPlaneRightStop,		name = _('Aircraft Bank Right'),	category = _('Flight Control')},
{down = iCommandPlaneLeftRudderStart,	up = iCommandPlaneLeftRudderStop,	name = _('Aircraft Rudder Left'),	category = _('Flight Control')},
{down = iCommandPlaneRightRudderStart,	up = iCommandPlaneRightRudderStop,	name = _('Aircraft Rudder Right'),	category = _('Flight Control')},

{down = iCommandPlaneTrimUp,	up = iCommandPlaneTrimUp,	 value_down = 1, value_up = 0, name = _('Elevator Trimmer Switch, PULL(CLIMB)'),	category = _('Flight Control')},
{down = iCommandPlaneTrimDown,	up = iCommandPlaneTrimDown,	 value_down = 1, value_up = 0, name = _('Elevator Trimmer Switch, PUSH(DESCEND)'),	category = _('Flight Control')},
{down = iCommandPlaneTrimLeft,	up = iCommandPlaneTrimLeft,	 value_down = 1, value_up = 0, name = _('Aileron Trimmer Switch, LEFT'),	category = _('Flight Control')},
{down = iCommandPlaneTrimRight,	up = iCommandPlaneTrimRight, value_down = 1, value_up = 0, name = _('Aileron Trimmer Switch, RIGHT'),	category = _('Flight Control')},

{pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  name = _('Thrust Smoothly Up'),	category = _('Flight Control')},
{pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  name = _('Thrust Smoothly Down'),	category = _('Flight Control')},

{down = iCommandPlaneAUTIncreaseRegime, name = _('Thrust Step Up'),	  category = _('Flight Control')},
{down = iCommandPlaneAUTDecreaseRegime, name = _('Thrust Step Down'), category = _('Flight Control')},

-- Systems
{down = iCommandPlaneAirBrake,		up = iCommandPlaneAirBrake,		value_down = 1,	value_up = 0,	name = _('Airbrake Button, Hold to extend'),		category = _('Systems')},
{down = iCommandPlaneAirBrakeOn,	up = iCommandPlaneAirBrakeOn,	value_down = 1,	value_up = 0,	name = _('Airbrake Switch, OPEN'),					category = _('Systems')},
{down = iCommandPlaneAirBrakeOff,	up = iCommandPlaneAirBrakeOff, 	value_down = 1,	value_up = 0,	name = _('Airbrake Switch, CLOSE'),					category = _('Systems')},
{down = iCommandPlaneFlaps,																			name = _('Wing Flaps Handle, Up/Down'),				category = _('Systems')},
{down = iCommandPlaneFlapsOn,																		name = _('Wing Flaps Handle, Down'),				category = _('Systems')},
{down = iCommandPlaneFlapsOff,																		name = _('Wing Flaps Handle, Up'),					category = _('Systems')},
{down = iCommandPlaneGear,																			name = _('Landing Gear Handle, Up/Down'),			category = _('Systems')},
{down = iCommandPlaneGearUp,																		name = _('Landing Gear Handle, Up'),				category = _('Systems')},
{down = iCommandPlaneGearDown,																		name = _('Landing Gear Handle, Down'),				category = _('Systems')},
{down = iCommandPlaneWheelBrakeOn,			up = iCommandPlaneWheelBrakeOff,						name = _('Wheel Brake On'),							category = _('Systems')},
{down = iCommandPlaneWheelBrakeRightOn,		up = iCommandPlaneWheelBrakeOff,						name = _('Forced Wheel Brake On'),					category = _('Systems')},
{down = iCommandPlaneFonar, 																		name = _('Canopy Open/Close'),						category = _('Systems')},
{down = iCommandPlaneEject,																			name = _('Eject (3 times)'),						category = _('Systems')},

{	down = iCommandPlanePickleOn,				up = iCommandPlanePickleOff,																								name = _('Weapon Release Button'),							category = {_('Stick')}},
{	down = weapons_commands.TrgFirstDetent,		up = weapons_commands.TrgFirstDetent,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down =  1, value_up = 0,	name = _('Gun Trigger - FIRST DETENT'), 					category = {_('Stick')}},
{	down = iCommandPlaneFire,					up = iCommandPlaneFireOff, 																									name = _('Gun Trigger - SECOND DETENT (Press to shoot)'),	category = {_('Stick')}},

{	down = iCommandPlaneChangeWeapon,	name = _('Cycle Weapon'),	category = _('Weapons')},


--{down = iCommandPlaneWingtipSmokeOnOff,		name = _('Smoke'),						category = _('Systems')},
--{down = iCommandPlaneJettisonWeapons, up = iCommandPlaneJettisonWeaponsUp, name = _('Weapons Jettison'), category = _('Systems')},
--{down = iCommandPlaneJettisonFuelTanks, up   = iCommandPlaneJettisonFuelTanksUp, name = _('Jettison Fuel Tanks'), category = _('Systems')},

--{down = iCommandViewLeftMirrorOn ,	up = iCommandViewLeftMirrorOff , name = _('Mirror Left On'), category = _('View Cockpit')},
--{down = iCommandViewRightMirrorOn,	up = iCommandViewRightMirrorOff, name = _('Mirror Right On'), category = _('View Cockpit')},
--{down = iCommandToggleMirrors, name = _('Toggle Mirrors'), category = _('View Cockpit')},


})

-- joystick axes 
join(res.axisCommands,{
{combos = defaultDeviceAssignmentFor("roll")	, action = iCommandPlaneRoll, name = _('Roll')},
{combos = defaultDeviceAssignmentFor("pitch")	, action = iCommandPlanePitch, name = _('Pitch')},
{combos = defaultDeviceAssignmentFor("rudder")	, action = iCommandPlaneRudder, name = _('Rudder')},
{combos = defaultDeviceAssignmentFor("thrust")	, action = iCommandPlaneThrustCommon, name = _('Thrust')},

{action = iCommandWheelBrake,		name = _('Wheel Brake')},

})

return res
